﻿var thetop = window.top;
var showOnlyActiveVariables = false;

var a4logicEditor = {
    queueSyncCalls: null,
    hasError: false,
    conditionRequired: false,
    variableSource: [],
    ajaxInitialData: null,

    runLogicInitialization: function () {
        if (a4logicEditor.queueSyncCalls) {
            a4logicEditor.queueSyncCalls.dequeue("init");
        }
    },

    setAutoComplete: function (item, row, excludeQuestionId, dataSource, isAjaxSrc) {
        var varsForSkip = [];
        var autoCompleteProp = {
            valueProperty: "value",
            labelProperty: "name",
            tooltipProperty: "questionId",
            tooltipData: function (autocomplete, tooltip, questionId) {
                if (questionId > 0) {
                    a4.getTooltipQuestionText(autocomplete, tooltip, a4.getSurveyId(), questionId);
                }
            },
            select: function (event, ui) {
                var row = $(event.target).closest("tr");
                $(".v-logicVariableId", row).val((ui.item) ? ui.item.value : "")

                var callback = function () { $('.v-logicOperator', row).trigger('change'); };
                if (isAjaxSrc) {
                    a4logicEditor.setAjaxValueOptions(row, ui.item, callback);
                }
                else {
                    a4logicEditor.setValueOptions(row, ((ui.item) ? ui.item.name : ""), callback);  // Refreshes the options (show autocomplete or not)
                }
            }
        };

        if (isAjaxSrc == undefined || !isAjaxSrc) {
            // For questions we don't show it's own variables
            if (excludeQuestionId && excludeQuestionId.length > 0) {
                varsForSkip = _.filter(a4logicEditor.variableSource, function (v) { return v.questionId != excludeQuestionId });
            }
            else if (dataSource) {
                autoCompleteProp["tooltipProperty"] = null;
                autoCompleteProp["tooltipData"] = null;

                _.each(dataSource.split(","), function (value, index) {
                    varsForSkip.push({ value: value, name: value });
                });
            }
            else {
                varsForSkip = a4logicEditor.variableSource;
            }
            autoCompleteProp["data"] = varsForSkip.filter(x => !x.isSecuredTemporaryVariable);
        }
        else {
            if (!dataSource || dataSource.length == 0) {
                dataSource = a4.getSurveyAction("GetVariablesList", "Shared", { surveyId: a4.getSurveyId(), onlyActiveVariables: showOnlyActiveVariables });
            }

            autoCompleteProp["ajaxAction"] = dataSource;
            autoCompleteProp["ajaxInitialData"] = a4logicEditor.ajaxInitialData;

        }

        item.a4autocomplete(autoCompleteProp);
        $("input", row).on("keypress", function (e) { return a4.disableEnter(e); });
    },

    initAutocomplete: function (skipEditor, manualInitialization, excludeAttr, source, isAjaxSrc) {
        $(".v-logicTable tbody tr .v-logicVariable", skipEditor).each(function () {
            var item = $(this);

            // Queue calls to wait for opstion to be set (when choices are not loaded we do a query to fetch the data)
            a4logicEditor.queueSyncCalls.queue("init", function (next) {
                var row = item.closest("tr");
                var value = $(".v-logicValue", row).val();    // Get original value and put back and sets complete

                a4logicEditor.setAutoComplete(item, row, excludeAttr, source, isAjaxSrc);
                var choiceListId = row.attr("data-choice-list-id");
                var variableName = $(".v-logicVariable", row).val()

                var callback = function () {
                    a4.setInputValue($(".v-logicValue", row), value);
                    next();
                };

                if (isAjaxSrc) {
                    a4logicEditor.setAjaxValueOptions(row, { choiceListId: choiceListId, variableId: $(".v-logicVariableId", row).val(), name: variableName }, callback)
                } else {
                    a4logicEditor.setValueOptions(row, item.val(), callback);
                }
            });
        });

        if (!manualInitialization) {
            a4logicEditor.runLogicInitialization();
        }

        if ($('.v-logicTable tbody tr:not(.deleted)', skipEditor).length == 0) {
            $('.v-logicTable', skipEditor).hide();
        }
    },

    setVariableAutoComplete: function (skipEditor, excludeQuestion, manualInitialization) {
        var excludeAttr = (excludeQuestion) ? excludeQuestion.attr("id").replace("blockItemPanel", "") : "";
        skipEditor.attr("data-exclude", excludeAttr);
        a4logicEditor.initAutocomplete(skipEditor, manualInitialization, excludeAttr, null);
    },

    setVariableAutoCompleteByList: function (skipEditor, variableNames, manualInitialization) {
        skipEditor.attr("data-source", variableNames);
        a4logicEditor.initAutocomplete(skipEditor, manualInitialization, null, variableNames);
    },

    setVariableAutoCompleteByAjax: function (skipEditor, ajaxFunction) {
        skipEditor.attr("data-source", ajaxFunction);
        skipEditor.attr("data-ajax", true);
        a4logicEditor.initAutocomplete(skipEditor, false, null, ajaxFunction, true);
    },

    addRow: function (skipLogicEditor) {
        var table = $(".v-logicTable .v-logicBody", skipLogicEditor);
        var rowId = $("tr:not(.deleted)", table).length + 1;

        table.append($(".v-newLogicRow tbody", skipLogicEditor).clone().html().replace("skipRow0", "skipRow" + rowId));
        $('.v-logicTable', skipLogicEditor).show();

        var row = $('tr:last', table);
        $(".v-itemIndex", row).text(rowId);

        if ($('tr:visible', table).length > 1) {
            $(".v-filterType", skipLogicEditor).show();
            $(".v-logicCondition", skipLogicEditor).trigger("change");
        }

        var excludeQuestion = skipLogicEditor.attr("data-exclude");
        var source = skipLogicEditor.attr("data-source");
        var isAjax = skipLogicEditor.attr("data-ajax");
        a4logicEditor.setAutoComplete($(".v-logicVariable", row), row, excludeQuestion, source, isAjax);
        skipLogicEditor.trigger('rowAdded', row);
        return row;
    },

    setValueOptions: function (row, variableValue, callback) {
        var variable = a4.top().questionnaireEditor.getVariableByName(variableValue);
        var varChoices = a4.top().questionnaireEditor.getChoicesByVariable(variableValue);

        if (variable && variable.choiceListId != "0" && varChoices.length == 0) {
            a4.top().questionnaireEditor.loadVariablesChoices(variable.choiceListId, variable.name, variable.questionId, variable.blockId,
                function () { a4logicEditor.completeSetValueOptions(a4.top().questionnaireEditor.getChoicesByVariable(variableValue), row, variableValue, callback); });
        }
        else {
            a4logicEditor.completeSetValueOptions(varChoices, row, variableValue, callback);
        }
    },

    setAjaxValueOptions: function (row, item, callback) {
        var logicVal = $(".v-logicValue", row);
        logicVal.val("");

        // Reset operator list
        a4logicEditor.displayOperatorOptions(row, item);

        if (item.choiceListId > 0) {
            logicVal.a4autocomplete({
                ajaxAction: a4.getSurveyAction("GetVariableChoicesList", "Shared", { surveyId: a4.getSurveyId() }),
                ajaxParams: { choiceListId: item.choiceListId },
                data: null,
                validateSelection: false,
                valueProperty: "Value",
                labelProperty: "Label"
            });
        }
        else if ((item.property && item.property == "[DispositionCode]") || item.name == "$DISPOSITION") {
            logicVal.a4autocomplete({
                data: top.EnumDetails.DispositionCode,
                validateSelection: false,
                valueProperty: "Value",
                labelProperty: "Label"
            });
        }
        else if (logicVal.hasClass("autocomplete")) {
            logicVal.a4autocomplete("destroy");
        }

        if (callback != undefined) {
            callback();
        }

        logicVal.on("keypress", function (e) { return a4.disableEnter(e); });
        a4logicEditor.displayValueOptions(row, $(".v-logicOperator", row).val());
    },

    completeSetValueOptions: function (varChoices, row, variableValue, callback) {
        var logicVal = $(".v-logicValue", row);
        logicVal.val("");

        if (varChoices && varChoices.length > 0) {
            varChoices = _.filter(varChoices, function (c) { return c.value && c.value != ""; });

            logicVal.a4autocomplete({
                data: varChoices,
                limitResults: 200,
                validateSelection: false,
                valueProperty: "value",
                labelProperty: "name"
            });
        }
        else if (logicVal.hasClass("autocomplete")) {
            logicVal.a4autocomplete("destroy");
        }

        logicVal.on("keypress", function (e) { return a4.disableEnter(e); });
        a4logicEditor.displayValueOptions(row, $(".v-logicOperator", row).val());

        if (callback != undefined) {
            callback();
        }
    },

    getExecutionCondition: function () {
        return a4logicEditor.getLogic($(".v-logicEditor"), false);
    },

    validateExecutionCondition: function () {
        var skipLogic = a4logicEditor.getLogic($(".v-logicEditor"), false);
        a4logicEditor.hasError = false;
        return a4logicEditor.validateLogic(skipLogic, $("#ActionCondition").text());
    },

    switchSyntaxType: function (link) {
        var skipLogicEditor = link.parents(".v-logicEditor");
        $(".v-editorType.inEdit", skipLogicEditor).hide();
        $(".v-editorType", skipLogicEditor).toggleClass("inEdit");
        $(".v-editorType.inEdit", skipLogicEditor).show();
        $(".syntaxHelper", skipLogicEditor.parent()).toggle();  // for selection actions
        a4logicEditor.checkEditorStatus(skipLogicEditor);
    },

    displayValueOptions: function (row, logicOperatorVal) {
        var logicVal = $(".v-logicValue", row);
        var autoComplete = logicVal.closest(".autocomplete-container");
        var valueHidden = (logicOperatorVal == "Empty" || logicOperatorVal == "NotEmpty");

        if (autoComplete.length > 0) {
            autoComplete.toggle(!valueHidden);
            logicVal.toggle(!valueHidden);
        }
        else {
            logicVal.toggle(!valueHidden);
        }
    },

    displayOperatorOptions: function (row, item) {
        var copy = $("select.v-logicOperatorCopy", row);

        if (copy.length == 0) {
            copy = $("select.v-logicOperator", row).clone().appendTo(row).removeClass("v-logicOperator").addClass("hidden v-logicOperatorCopy");
        }
        else {
            $("select.v-logicOperator", row).html(copy.html());
        }

        if (item.property || item.variableId == "0") {
            $("select.v-logicOperator option:not(.basicOperator)", row).remove();
        }
    },

    checkEditorStatus: function (skipLogicEditor) {
        var _condition = $(".v-advanceCondition:visible", skipLogicEditor).length > 0
                    ? $(".v-advanceCondition", skipLogicEditor).val()
                    : $(".v-customValueSequence", skipLogicEditor).val();

        if (($(".v-advancedEditor:visible", skipLogicEditor).length > 0 && $(".v-syntaxTypeStartValue", skipLogicEditor).val() != "Advanced")
            || ($(".v-logicCondition", skipLogicEditor).val() != $(".v-startLogicCondition", skipLogicEditor).val())
            || _condition != $(".v-syntaxConditionStartValue", skipLogicEditor).val()) {
            skipLogicEditor.addClass("updated");
        }
        else {
            skipLogicEditor.removeClass("updated");
        }
    },

    completeChangeConditionType: function (editor, value) {
        var nbCondition = $(".v-logicTable tbody tr:not(.deleted)", editor).length;
        $(".v-customFilterBlock", editor).toggle(value == "Custom" && nbCondition > 1);
        a4logicEditor.checkEditorStatus(editor);
    },

    simpleLogicMultipleSelectionSelect: function (editor, value) {
        $("div.v-logicRow", editor).addClass("hidden");
        //_.each($("div.v-logicRow[data-varId!=" + value + "]", editor), function (row) { $(row).addClass("hidden"); });
        _.each($("div.v-logicRow[data-varId=" + value + "]", editor), function (row) { $(row).removeClass("hidden"); });
    },

    editInlineTypeLogic: function (logicEditor, logic, allowAdvance) {
        $('.v-advanceLink', logicEditor).toggle(allowAdvance);

        if (logic) {
            $('.v-advanceCondition', logicEditor).empty();

            if (logic.SyntaxType == "Advanced") {
                a4logicEditor.switchSyntaxType($('.v-advanceLink', logicEditor));
                $('.v-advanceCondition', logicEditor).append(logic.CustomCondition);
            }
            else {
                if (logic.Conditions.length > 1) {
                    $(".v-filterType", logicEditor).show();

                    if (logic.ConditionType == "Custom") {
                        $(".customFilterBlock", logicEditor).show();
                    }
                }

                $(".v-logicCondition option[value='" + logic.ConditionType + "']", logicEditor).attr("selected", "selected");
                $(".v-logicCondition", logicEditor).val(logic.ConditionType);
                $('.v-customValueSequence', logicEditor).attr("value", logic.CustomCondition);
                a4logicEditor.completeChangeConditionType(logicEditor, logic.ConditionType);
            }
        }
    },

    editInlineConditionLogic: function (logicEditor, logic, inEditQuestion) {
        //a4logicEditor.setVariableAutoComplete(logicEditor, inEditQuestion);

        if (logic) {
            _.each(logic.Conditions, function (condition) {
                var row = $(a4logicEditor.addRow(logicEditor)).attr('id', 'LogicRow' + condition.Id);

                if (condition.VariableId && parseInt(condition.VariableId, 10) > 0) {
                    var variableAutoComplete = $('.v-logicVariable', row);
                    var variable = a4.top().questionnaireEditor.getVariableById(condition.VariableId);
                    variableAutoComplete.val(variable.name);
                    $('.v-logicVariableId', row).val(variable.value);
                    a4logicEditor.setValueOptions(row, variable.name, function () {
                        a4.setInputValue($(".v-logicValue", row), condition.Value);
                    });
                    $('.v-logicOperator', row).val(condition.Operator);
                }
                else if (logicEditor.attr("data-source") && $.inArray(condition.VariableName, logicEditor.attr("data-source").split(",")) > -1) {
                    var variableAutoComplete = $('.v-logicVariable', row);
                    variableAutoComplete.val(condition.VariableName);
                    $('.v-logicVariableId', row).val(condition.VariableId);
                    a4logicEditor.setValueOptions(row, condition.VariableName, function () {
                        a4.setInputValue($(".v-logicValue", row), condition.Value);
                    });
                    $('.v-logicOperator', row).val(condition.Operator);
                }
            });
        }
    },

    initializeSimpleLogic: function (editor) {
        var multipleVarSelection = $(".v-simpleLogicVariable:visible", editor);

        if (multipleVarSelection.length > 0) {
            var selection = a4logicEditor.getSimpleMultipleSelection(multipleVarSelection);
            a4logicEditor.simpleLogicMultipleSelectionSelect(editor, selection);
        }
    },

    getSimpleMultipleSelection: function (select) {
        var item = $("option:selected", select);
        return (item && item.length > 0) ? item.attr("id").replace("variable", "") : null;
    },

    setEvents: function (context) {
        // Add row
        $(context).on("click", ".h-addLogicRow", function () {
            var skipLogicEditor = $(this).parents(".lookup-table-filter").find(".v-logicEditor");
            if (!skipLogicEditor.length) {
                skipLogicEditor = $(this).closest(".v-logicEditor");
            }
            var row = a4logicEditor.addRow(skipLogicEditor);
            $(".v-logicVariable", row).removeAttr("style");
            $(".v-logicValue", row).removeAttr("style");
        });

        // Delete row
        $(context).on("click", ".v-logicEditor .h-deleteLogicRow", function () {
            var skipLogicEditor = $(this).closest(".v-logicEditor");
            var item = $(this).closest("tr");
            item.addClass("deleted").hide();

            // If 1 item left visible then hide filtertype
            if (item.siblings("tr:not(.deleted)").length == 1) {
                $(".v-filterType", skipLogicEditor).hide();
            }

            if (item.siblings("tr:not(.deleted)").length > 0) {
                $(".v-logicCondition", skipLogicEditor).trigger("change");
            }

            if ($('.v-logicTable tbody tr:not(.deleted)', skipLogicEditor).length == 0) {
                $('.v-logicTable', skipLogicEditor).hide();
            }
        });

        // Condition change
        $(context).on("change", ".v-logicEditor .v-logicCondition", function () {
            var skipLogicEditor = $(this).closest(".v-logicEditor");
            a4logicEditor.completeChangeConditionType(skipLogicEditor, $(this).val());
        });

        // Operator change
        $(context).on("change", ".v-logicEditor .v-logicOperator", function () {
            var row = $(this).closest(".v-logicRow");
            row.addClass("updated");
            a4logicEditor.displayValueOptions(row, $(this).val());
        });

        // Value change
        $(context).on("change", ".v-logicEditor .v-logicValue", function () {
            $(this).closest(".tr").addClass("updated");
        });

        // Syntax edit
        $(context).on("click", ".v-logicEditor .h-editorSyntaxType", function () {
            a4logicEditor.switchSyntaxType($(this));
        });

        // Custom syntaxt events
        $(context).on("blur", ".v-logicEditor .v-customValueSequence,.v-logicEditor .v-advanceCondition", function () {
            a4logicEditor.checkEditorStatus($(this).closest(".v-logicEditor"));
        });

        // Simple logic multi variable selection
        $(context).on("change", ".v-branchSimpleLogic .v-simpleLogicVariable", function () {
            var editor = $(this).closest(".v-branchSimpleLogic");
            var selection = a4logicEditor.getSimpleMultipleSelection($(this));
            a4logicEditor.simpleLogicMultipleSelectionSelect(editor, selection);
        });
    },

    validateLogic: function (logic, section) {
        a4logicEditor.hasError = false;

        if (logic) {
            var conditions = logic.Conditions || [];

            if (a4logicEditor.conditionRequired && conditions.length == 0) {
                a4logicEditor.hasError = true;
                a4.showErrorMessage(a4.top().sharedResources.ErrorLogicRequired);
            }
            else {
                $.each(conditions, function (index, condition) {
                    if (!a4logicEditor.hasError) {
                        a4logicEditor.validateLogicItem(condition, section);
                    }
                });
            }

            if (!a4logicEditor.hasError && logic.SyntaxType == "Normal" && logic.Conditions != null && logic.Conditions.length > 0 && logic.ConditionType == "Custom" && logic.CustomCondition == "") {
                a4.showErrorMessage(a4.top().sharedResources.ErrorLogicConditionIsRequired.replace("{0}", section));
                a4logicEditor.hasError = true;
                return false;
            }
        }

        return !a4logicEditor.hasError;
    },

    validateLogicItem: function (logicItem, section) {
        if (!logicItem.VariableId || logicItem.VariableName == "") {
            var message = (logicItem.VariableName == "") ? a4.top().sharedResources.ErrorLogicEmptyVariable : a4.top().sharedResources.ErrorLogicVariable;
            a4.showErrorMessage(message.replace("{0}", section).replace("{1}", "#" + logicItem.Index));
            a4logicEditor.hasError = true;
        }
        else if ((!logicItem.Value || logicItem.Value == "") && logicItem.Operator != "Empty" && logicItem.Operator != "NotEmpty") {
            a4.showErrorMessage(a4.top().sharedResources.ErrorLogicValue.replace("{0}", section).replace("{1}", "#" + logicItem.Index));
            a4logicEditor.hasError = true;
        }
    },

    validateClientSideLogic: function (logic, variablesList, section) {
        a4logicEditor.hasError = false;

        if (logic) {
            $.each(logic.Conditions || [], function (index, condition) {
                if (!a4logicEditor.hasError) {
                    a4logicEditor.validateClientSideLogicItem(condition, variablesList, section);
                }
            });
        }

        return !a4logicEditor.hasError;
    },

    validateClientSideLogicItem: function (logicItem, variablesList, section) {
        if ($.inArray(logicItem.VariableName.toUpperCase(), variablesList) == -1) {
            var message = (logicItem.VariableName == "") ? a4.top().sharedResources.ErrorLogicEmptyVariable : a4.top().sharedResources.ErrorLogicVariable;
            a4.showErrorMessage(message.replace("{0}", section).replace("{1}", "#" + logicItem.Index));
            a4logicEditor.hasError = true;
        }
        else if ((!logicItem.Value || logicItem.Value == "") && logicItem.Operator != "Empty" && logicItem.Operator != "NotEmpty") {
            a4.showErrorMessage(a4.top().sharedResources.ErrorLogicValue.replace("{0}", section).replace("{1}", "#" + logicItem.Index));
            a4logicEditor.hasError = true;
        }
    },

    getLogic: function (editor, validate) {
        var logic = {};
        logic.SyntaxType = ($(".v-advancedEditor", editor).hasClass("inEdit")) ? "Advanced" : "Normal";
        logic.Conditions = (logic.SyntaxType == "Advanced") ? [] : $(".v-logicTable tbody tr:not(.deleted)", editor).map(function () { return a4logicEditor.createLogicConditionObject($(this)); }).get();
        logic.ConditionType = (logic.SyntaxType == "Advanced") ? "Custom" : (logic.Conditions.length > 1) ? $(".v-logicCondition", editor).val() : "And";
        logic.CustomCondition = (logic.ConditionType == "Custom") ? (logic.SyntaxType == "Normal") ? $(".v-customValueSequence", editor).val() : $(".v-advanceCondition", editor).val().replace(/([^])(<)([a-zA-Z0-9])/g, "$1 $2 $3") : "";

        if (validate) {
            a4logicEditor.validateLogic(logic, "");
        }

        return logic;
    },

    createLogicConditionObject: function (logicRow) {
        var logicEditor = logicRow.closest('.v-logicEditor');
        var item = new Object();

        item.Id = logicRow.attr("id").replace("LogicRow", "");
        item.Index = $(".v-itemIndex", logicRow).text();
        item.VariableName = $(".v-logicVariable", logicRow).val();
        item.VariableId = $(".v-logicVariableId", logicRow).val();
        item.Operator = $(".v-logicOperator", logicRow).val();

        var value = $(".v-logicValue", logicRow);
        value = value.attr("data-value") !== undefined ? value.attr("data-value") : value.val();
        item.Value = value.replace(/\\'/g, "'");

        return item;
    },

    createBasicLogicObject: function (editor) {
        var logic = {};
        logic.SyntaxType = "Normal";
        logic.Conditions = $(".v-choiceCondition input:checked,.v-valueCondition .v-logicValue", editor).map(function () { return a4logicEditor.createLogicConditionObject($(this).closest(".v-logicRow")); }).get();
        logic.Conditions = _.reject(logic.Conditions, function (c) { return c.Value == "" && c.Operator != "IsEmpty" && c.Operator != "NotEmpty" });
        logic.ConditionType = "Or";
        logic.CustomCondition = (_.size(logic.Conditions) > 1) ? _.pluck(logic.Conditions, "Index").join(" OR ") : "";
        return logic;
    },

    isEmptyLogic: function (logic) {
        return ((logic.SyntaxType == "Normal" && _.size(logic.Conditions) == 0) || (logic.SyntaxType == "Advanced" && logic.CustomCondition == ""));
    },

    initializeEditors: function (context, variables, disableAdvance, showOnlyActiveItems = false) {
        a4logicEditor.queueSyncCalls = $({});

        var questionData = (variables ? variables : a4.top().questionnaireEditor.getSortedVariables());
        a4logicEditor.variableSource = questionData ? questionData.filter(b => b.qType != 37) : questionData;
        a4logicEditor.setEvents(context);

        if (disableAdvance) {
            $('.v-advanceLink', context).remove();
        }
        if (showOnlyActiveItems) {
            showOnlyActiveVariables = showOnlyActiveItems;
        }
    },

    updateVariables: function (variables) {
        var questionData = (variables ? variables : a4.top().questionnaireEditor.getSortedVariables());
        a4logicEditor.variableSource = questionData ? questionData.filter(b => b.qType != 37) : questionData;
    },

    replaceItemIndexes: function (startItem, increaseStartItem) {
        // Replace order if item deleted
        var previousIndex = $(".v-itemIndex", startItem).html();

        // For cancel of delete
        if (increaseStartItem) {
            previousIndex++;
        }

        startItem.nextAll(".v-questionEditableItem:visible").each(function () {
            $(".v-itemIndex", $(this)).html(previousIndex);
            previousIndex++;
        });
    }
};
